//###############################################################
// Preset.cpp : Deal with preset related action
//
// S_GotoPresetPoint()	:	Drive cam goto position
// S_GetPresetPara()	:	Get preset parameter from EE
// S_PresetIDToNum()	:	Transfer ID to Number
//###############################################################

#include "stdafx.h"
#include "Define.h"
#include "SpeedDome.h"
#include "misc.h"
#include "Comm.h"
#include "Preset.h"
#include "define.h"
#include "GlobalVar.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//###############################################################
//
// S_GotoPresetPoint( unsigned int Y_Point )
//
// Y_Point	: Preset point 
//###############################################################
void CPreset::S_GotoPresetPoint(unsigned int Y_Point)
{
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[12]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";

//CComm::S_COM_PanSpeed(14);
//CComm::S_COM_TiltSpeed(14);
//---- Goto preset position -----------------------------
char			Pkt[6]={'\x0','\x0','\x11','\x0','\x0','\x0'};
Pkt[0]=(char)G_DomeID;
Pkt[3]='\x03';
Pkt[4]=(char)(Y_Point-1);
Pkt[5]=(((Pkt[0]^Pkt[1])^Pkt[2] )^Pkt[3])^Pkt[4];

CComm::RTS_WriteReadFile(hcom,Pkt,6,&NumberOfBytesWritten,NULL,
				  Buffer,&NumberOfBytesRead,G_DelayTime);

}

//###############################################################
//
// int S_PresetIDToNum(UINT ID)
//
// ID : Preset point ID
//###############################################################
UINT	CPreset::S_PresetIDToNum(UINT ID,LPTSTR *IDBName)
{
UINT	Num;
UINT	IDBBuffer[12]=
		{	IDB_PRESET_NUM1D ,IDB_PRESET_NUM2D ,IDB_PRESET_NUM3D,
			IDB_PRESET_NUM4D ,IDB_PRESET_NUM5D ,IDB_PRESET_NUM6D,
			IDB_PRESET_NUM7D ,IDB_PRESET_NUM8D ,IDB_PRESET_NUM9D,	
			IDB_PRESET_NUM10D,IDB_PRESET_NUM11D,IDB_PRESET_MORED };

switch(ID)
	{
	case IDC_PRESET_MORE  : Num=12;	break;
	//--------
	case IDC_PRESET_NUM1  : Num=1;	break;	case IDC_PRESET_NUM2  : Num=2;	break;
	case IDC_PRESET_NUM3  : Num=3;	break;	case IDC_PRESET_NUM4  : Num=4;	break;
	case IDC_PRESET_NUM5  : Num=5;	break;	case IDC_PRESET_NUM6  : Num=6;	break;
	case IDC_PRESET_NUM7  : Num=7;	break;	case IDC_PRESET_NUM8  : Num=8;	break;
	case IDC_PRESET_NUM9  : Num=9;	break;	case IDC_PRESET_NUM10 : Num=10;	break;
	case IDC_PRESET_NUM11 : Num=11;	break;	case IDC_PRESET_NUM12 : Num=12;	break;
	case IDC_PRESET_NUM13 : Num=13;	break;	case IDC_PRESET_NUM14 : Num=14;	break;
	case IDC_PRESET_NUM15 : Num=15;	break;	case IDC_PRESET_NUM16 : Num=16;	break;
	case IDC_PRESET_NUM17 : Num=17;	break;	case IDC_PRESET_NUM18 : Num=18;	break;
	case IDC_PRESET_NUM19 : Num=19;	break;	case IDC_PRESET_NUM20 : Num=20;	break;
	//-------
	case IDC_PRESET_NUM21 : Num=21;	break;	case IDC_PRESET_NUM22 : Num=22;	break;
	case IDC_PRESET_NUM23 : Num=23;	break;	case IDC_PRESET_NUM24 : Num=24;	break;
	case IDC_PRESET_NUM25 : Num=25;	break;	case IDC_PRESET_NUM26 : Num=26;	break;
	case IDC_PRESET_NUM27 : Num=27;	break;	case IDC_PRESET_NUM28 : Num=28;	break;
	case IDC_PRESET_NUM29 : Num=29;	break;	case IDC_PRESET_NUM30 : Num=30;	break;
	case IDC_PRESET_NUM31 : Num=31;	break;	case IDC_PRESET_NUM32 : Num=32;	break;
	case IDC_PRESET_NUM33 : Num=33;	break;	case IDC_PRESET_NUM34 : Num=34;	break;
	case IDC_PRESET_NUM35 : Num=35;	break;	case IDC_PRESET_NUM36 : Num=36;	break;
	case IDC_PRESET_NUM37 : Num=37;	break;	case IDC_PRESET_NUM38 : Num=38;	break;
	case IDC_PRESET_NUM39 : Num=39;	break;	case IDC_PRESET_NUM40 : Num=40;	break;
	//------
	case IDC_PRESET_NUM41 : Num=41;	break;	case IDC_PRESET_NUM42 : Num=42;	break;
	case IDC_PRESET_NUM43 : Num=43;	break;	case IDC_PRESET_NUM44 : Num=44;	break;
	case IDC_PRESET_NUM45 : Num=45;	break;	case IDC_PRESET_NUM46 : Num=46;	break;
	case IDC_PRESET_NUM47 : Num=47;	break;	case IDC_PRESET_NUM48 : Num=48;	break;
	case IDC_PRESET_NUM49 : Num=49;	break;	case IDC_PRESET_NUM50 : Num=50;	break;
	case IDC_PRESET_NUM51 : Num=51;	break;	case IDC_PRESET_NUM52 : Num=52;	break;
	case IDC_PRESET_NUM53 : Num=53;	break;	case IDC_PRESET_NUM54 : Num=54;	break;
	case IDC_PRESET_NUM55 : Num=55;	break;	case IDC_PRESET_NUM56 : Num=56;	break;
	case IDC_PRESET_NUM57 : Num=57;	break;	case IDC_PRESET_NUM58 : Num=58;	break;
	case IDC_PRESET_NUM59 : Num=59;	break;	case IDC_PRESET_NUM60 : Num=60;	break;
	//-----
	case IDC_PRESET_NUM61 : Num=61;	break;	case IDC_PRESET_NUM62 : Num=62;	break;
	case IDC_PRESET_NUM63 : Num=63;	break;	case IDC_PRESET_NUM64 : Num=64;	break;
	case IDC_PRESET_NUM65 : Num=65;	break;	case IDC_PRESET_NUM66 : Num=66;	break;
	case IDC_PRESET_NUM67 : Num=67;	break;	case IDC_PRESET_NUM68 : Num=68;	break;
	case IDC_PRESET_NUM69 : Num=69;	break;	case IDC_PRESET_NUM70 : Num=70;	break;
	case IDC_PRESET_NUM71 : Num=71;	break;	case IDC_PRESET_NUM72 : Num=72;	break;
	case IDC_PRESET_NUM73 : Num=73;	break;	case IDC_PRESET_NUM74 : Num=74;	break;
	case IDC_PRESET_NUM75 : Num=75;	break;	case IDC_PRESET_NUM76 : Num=76;	break;
	case IDC_PRESET_NUM77 : Num=77;	break;	case IDC_PRESET_NUM78 : Num=78;	break;
	case IDC_PRESET_NUM79 : Num=79;	break;	case IDC_PRESET_NUM80 : Num=80;	break;
	//-----
	case IDC_PRESET_NUM81 : Num=81;	break;	case IDC_PRESET_NUM82 : Num=82;	break;
	case IDC_PRESET_NUM83 : Num=83;	break;	case IDC_PRESET_NUM84 : Num=84;	break;
	case IDC_PRESET_NUM85 : Num=85;	break;	case IDC_PRESET_NUM86 : Num=86;	break;
	case IDC_PRESET_NUM87 : Num=87;	break;	case IDC_PRESET_NUM88 : Num=88;	break;
	case IDC_PRESET_NUM89 : Num=89;	break;	case IDC_PRESET_NUM90 : Num=90;	break;
	case IDC_PRESET_NUM91 : Num=91;	break;	case IDC_PRESET_NUM92 : Num=92;	break;
	case IDC_PRESET_NUM93 : Num=93;	break;	case IDC_PRESET_NUM94 : Num=94;	break;
	case IDC_PRESET_NUM95 : Num=95;	break;	case IDC_PRESET_NUM96 : Num=96;	break;
	case IDC_PRESET_NUM97 : Num=97;	break;	case IDC_PRESET_NUM98 : Num=98;	break;
	case IDC_PRESET_NUM99 : Num=99;	break;	case IDC_PRESET_NUM100: Num=100;break;
	//-----
	case IDC_PRESET_NUM101 : Num=101;	break;	case IDC_PRESET_NUM102 : Num=102;	break;
	case IDC_PRESET_NUM103 : Num=103;	break;	case IDC_PRESET_NUM104 : Num=104;	break;
	case IDC_PRESET_NUM105 : Num=105;	break;	case IDC_PRESET_NUM106 : Num=106;	break;
	case IDC_PRESET_NUM107 : Num=107;	break;	case IDC_PRESET_NUM108 : Num=108;	break;
	case IDC_PRESET_NUM109 : Num=109;	break;	case IDC_PRESET_NUM110 : Num=110;	break;
	case IDC_PRESET_NUM111 : Num=111;	break;	case IDC_PRESET_NUM112 : Num=112;	break;
	case IDC_PRESET_NUM113 : Num=113;	break;	case IDC_PRESET_NUM114 : Num=114;	break;
	case IDC_PRESET_NUM115 : Num=115;	break;	case IDC_PRESET_NUM116 : Num=116;	break;
	case IDC_PRESET_NUM117 : Num=117;	break;	case IDC_PRESET_NUM118 : Num=118;	break;
	case IDC_PRESET_NUM119 : Num=119;	break;	case IDC_PRESET_NUM120 : Num=120;	break;
	//-----
	case IDC_PRESET_NUM121 : Num=121;	break;	case IDC_PRESET_NUM122 : Num=122;	break;
	case IDC_PRESET_NUM123 : Num=123;	break;	case IDC_PRESET_NUM124 : Num=124;	break;
	case IDC_PRESET_NUM125 : Num=125;	break;	case IDC_PRESET_NUM126 : Num=126;	break;
	case IDC_PRESET_NUM127 : Num=127;	break;	case IDC_PRESET_NUM128 : Num=128;	break;

	}
if (Num<=12)
	*IDBName=MAKEINTRESOURCE( IDBBuffer[Num-1] );

return (Num);
}


//###############################################################
//
// S_GetPresetParaEE(WORD Y_Point,char *Para)
//
// Y_Point	: Preset point which you want it data.
// Y_Para	: Preset point parameter string 
//###############################################################
void CPreset::S_GetPresetParaEE(WORD Y_Point,char *Para)
{
char			Y_Para[10]="\x00\x00\x00\x00\x00\x00\x00\x00\x00";
char			EEAddr[3];
WORD			Y_Addr;

Y_Addr=EE_BASE_PRESET+(Y_Point-1)*EE_SIZE_PRESET;

EEAddr[0]=LOBYTE(Y_Addr);
EEAddr[1]=HIBYTE(Y_Addr);

CComm::S_COM_AccessEEData(1,EEAddr,EE_SIZE_PRESET,Y_Para);  //-- Get Preset parameter

for( int i=0; i<=(EE_SIZE_PRESET-1) ; i++ )
	*(Para+i)=Y_Para[i];

if( (Y_Para[0]=='\xff')&&(Y_Para[1]=='\xff') )
	{	*Para=0;		*(Para+1)=0;	}
if( (Y_Para[2]=='\xff')&&(Y_Para[3]=='\xff') )
	{	*(Para+2)=0;	*(Para+3)=0;	}
if( (Y_Para[4]=='\xff')&&(Y_Para[5]=='\xff') )
	{	*(Para+4)=0;	*(Para+5)=0;	}
if( (Y_Para[6]=='\xff')&&(Y_Para[7]=='\xff') )
	{	*(Para+6)=0;	*(Para+7)=0;	}

}


//###############################################################
//
// S_GetPresetParaFiles(WORD Y_Point,char *Para)
//
// Y_Point	: Preset point which you want it data.
// Y_Para	: Preset point parameter string 
//###############################################################
void CPreset::S_GetPresetParaFiles(UINT Num,char *Para)
{

HANDLE			hSQ,hMap;
unsigned char 	*Fptr;
UINT			Temp;

hSQ=CreateFile("Preset.rec",GENERIC_READ,FILE_SHARE_READ,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
hMap=CreateFileMapping( hSQ,NULL,PAGE_READONLY,0,0,NULL);
Fptr=(unsigned char *)MapViewOfFile(hMap,FILE_MAP_READ,0,0,0);

Num=(Num-1)*EE_SIZE_PRESET;

for(int i=0;i<=(EE_SIZE_PRESET-1);i++)
	{
	Temp=*(Fptr+i+Num);
	if(Temp==0xff)
		*(Para+i)=0;
	else
		*(Para+i)=*(Fptr+i+Num);
	}

UnmapViewOfFile(Fptr); 
CloseHandle(hMap);
CloseHandle(hSQ);

}

//###############################################################
//
// S_GetPresetParaDlg()
//
//###############################################################

void CPreset::S_GetPresetParaDlg(char *Para)
{
unsigned short	PanDegEE=0,TiltDegEE=0;
unsigned short	ZoomEE=0,FocusEE=0;
unsigned char	LByte,HByte;

PanDegEE=(unsigned short) (G_PresetDlg->m_nPanDeg*768/360);
TiltDegEE=(unsigned short) (G_PresetDlg->m_nTiltDeg*240/90);
ZoomEE=(unsigned short) G_PresetDlg->m_nZoom;
FocusEE=(unsigned short) G_PresetDlg->m_nFocus;

S_WordTo2Bytes(PanDegEE,&LByte,&HByte);		Para[0]=LByte;	Para[1]=HByte;
S_WordTo2Bytes(TiltDegEE,&LByte,&HByte);	Para[2]=LByte;	Para[3]=HByte;
S_WordTo2Bytes(ZoomEE,&LByte,&HByte);		Para[4]=LByte;	Para[5]=HByte;
S_WordTo2Bytes(FocusEE,&LByte,&HByte);		Para[6]=LByte;	Para[7]=HByte;

}


//###############################################################
//
// S_PresetClearFile()
//
//###############################################################

void CPreset::S_PresetClearFile()
{

char	Para[9]="\xff\xff\xff\xff\xff\xff\xff\xff";
UINT	PresetNum=0;
LPTSTR	NoUse;

PresetNum=S_PresetIDToNum(G_RCtrlID,&NoUse);
CPreset::S_WritePresetParaFile(PresetNum,Para);

}


//###############################################################
//
// S_GetPresetNameFiles(WORD Y_Point,char *Para)
//
// Y_Point	: Preset point which you want it data.
// Y_Para	: Preset point parameter string 
//###############################################################
void CPreset::S_GetPresetNameFiles(UINT Num,char *Para)
{

HANDLE			hPT,hMap;
unsigned char 	*Fptr;
UINT			Temp;
UINT			DomeID;

DomeID=(UINT)G_DomeID;
long Block=DomeID*AVL_NUM_PRESET*16;

hPT=CreateFile("PresetName.rec",GENERIC_READ,FILE_SHARE_READ,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
hMap=CreateFileMapping( hPT,NULL,PAGE_READONLY,0,0,NULL);
Fptr=(unsigned char *)MapViewOfFile(hMap,FILE_MAP_READ,0,0,0);

Num=(Num-1)*16;

for(int i=0;i<=15;i++)
	{
	Temp=*(Fptr+Block+i+Num);
	if(Temp==0xff)
		*(Para+i)=0;
	else
		*(Para+i)=*(Fptr+Block+i+Num);
	}

UnmapViewOfFile(Fptr); 
CloseHandle(hMap);
CloseHandle(hPT);

}

//###############################################################
//
// S_WritePresetNameFiles(WORD Y_Point,char *Para)
//
// Y_Point	: Preset point which you want it data.
// Y_Para	: Preset point parameter string 
//###############################################################
void CPreset::S_WritePresetNameFiles(UINT Num,char *Para)
{

HANDLE			hPT,hMap;
unsigned char 	*Fptr;
UINT			DomeID;

DomeID=(UINT)G_DomeID;
long Block=DomeID*AVL_NUM_PRESET*16;

hPT=CreateFile("PresetName.rec",GENERIC_READ|GENERIC_WRITE,
			   FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
			   FILE_ATTRIBUTE_NORMAL,NULL);
hMap=CreateFileMapping( hPT,NULL,PAGE_READWRITE,0,0,NULL);
Fptr=(unsigned char *)MapViewOfFile(hMap,FILE_MAP_WRITE,0,0,0);

Num=(Num-1)*16;

for(int i=0;i<=15;i++)
	{
	*(Fptr+Block+i+Num)=Para[i];
	}

UnmapViewOfFile(Fptr); 
CloseHandle(hMap);
CloseHandle(hPT);

}


//###############################################################
//
// UINT S_PresetNumToID(UINT Num)
//
// ID : Preset point ID
//###############################################################
UINT	CPreset::S_PresetNumToID(UINT Num)
{
UINT	ID;

switch(Num)
	{
	//--------
	case  1: ID=IDC_PRESET_NUM1;	break;	case  2: ID=IDC_PRESET_NUM2;	break;
	case  3: ID=IDC_PRESET_NUM3;	break;	case  4: ID=IDC_PRESET_NUM4;	break;
	case  5: ID=IDC_PRESET_NUM5;	break;	case  6: ID=IDC_PRESET_NUM6;	break;
	case  7: ID=IDC_PRESET_NUM7;	break;	case  8: ID=IDC_PRESET_NUM8;	break;
	case  9: ID=IDC_PRESET_NUM9;	break;	case 10: ID=IDC_PRESET_NUM10;	break;
	case 11: ID=IDC_PRESET_NUM11;	break;	case 12: ID=IDC_PRESET_NUM12;	break;
	case 13: ID=IDC_PRESET_NUM13;	break;	case 14: ID=IDC_PRESET_NUM14;	break;
	case 15: ID=IDC_PRESET_NUM15;	break;	case 16: ID=IDC_PRESET_NUM16;	break;
	case 17: ID=IDC_PRESET_NUM17;	break;	case 18: ID=IDC_PRESET_NUM18;	break;
	case 19: ID=IDC_PRESET_NUM19;	break;	case 20: ID=IDC_PRESET_NUM20;	break;
	//-------
	case 21: ID=IDC_PRESET_NUM21;	break;	case 22: ID=IDC_PRESET_NUM22;	break;
	case 23: ID=IDC_PRESET_NUM23;	break;	case 24: ID=IDC_PRESET_NUM24;	break;
	case 25: ID=IDC_PRESET_NUM25;	break;	case 26: ID=IDC_PRESET_NUM26;	break;
	case 27: ID=IDC_PRESET_NUM27;	break;	case 28: ID=IDC_PRESET_NUM28;	break;
	case 29: ID=IDC_PRESET_NUM29;	break;	case 30: ID=IDC_PRESET_NUM30;	break;
	case 31: ID=IDC_PRESET_NUM31;	break;	case 32: ID=IDC_PRESET_NUM32;	break;
	case 33: ID=IDC_PRESET_NUM33;	break;	case 34: ID=IDC_PRESET_NUM34;	break;
	case 35: ID=IDC_PRESET_NUM35;	break;	case 36: ID=IDC_PRESET_NUM36;	break;
	case 37: ID=IDC_PRESET_NUM37;	break;	case 38: ID=IDC_PRESET_NUM38;	break;
	case 39: ID=IDC_PRESET_NUM39;	break;	case 40: ID=IDC_PRESET_NUM40;	break;
	//-------
	case 41: ID=IDC_PRESET_NUM41;	break;	case 42: ID=IDC_PRESET_NUM42;	break;
	case 43: ID=IDC_PRESET_NUM43;	break;	case 44: ID=IDC_PRESET_NUM44;	break;
	case 45: ID=IDC_PRESET_NUM45;	break;	case 46: ID=IDC_PRESET_NUM46;	break;
	case 47: ID=IDC_PRESET_NUM47;	break;	case 48: ID=IDC_PRESET_NUM48;	break;
	case 49: ID=IDC_PRESET_NUM49;	break;	case 50: ID=IDC_PRESET_NUM50;	break;
	case 51: ID=IDC_PRESET_NUM51;	break;	case 52: ID=IDC_PRESET_NUM52;	break;
	case 53: ID=IDC_PRESET_NUM53;	break;	case 54: ID=IDC_PRESET_NUM54;	break;
	case 55: ID=IDC_PRESET_NUM55;	break;	case 56: ID=IDC_PRESET_NUM56;	break;
	case 57: ID=IDC_PRESET_NUM57;	break;	case 58: ID=IDC_PRESET_NUM58;	break;
	case 59: ID=IDC_PRESET_NUM59;	break;	case 60: ID=IDC_PRESET_NUM60;	break;
	//-------
	case 61: ID=IDC_PRESET_NUM61;	break;	case 62: ID=IDC_PRESET_NUM62;	break;
	case 63: ID=IDC_PRESET_NUM63;	break;	case 64: ID=IDC_PRESET_NUM64;	break;
	case 65: ID=IDC_PRESET_NUM65;	break;	case 66: ID=IDC_PRESET_NUM66;	break;
	case 67: ID=IDC_PRESET_NUM67;	break;	case 68: ID=IDC_PRESET_NUM68;	break;
	case 69: ID=IDC_PRESET_NUM69;	break;	case 70: ID=IDC_PRESET_NUM70;	break;
	case 71: ID=IDC_PRESET_NUM71;	break;	case 72: ID=IDC_PRESET_NUM72;	break;
	case 73: ID=IDC_PRESET_NUM73;	break;	case 74: ID=IDC_PRESET_NUM74;	break;
	case 75: ID=IDC_PRESET_NUM75;	break;	case 76: ID=IDC_PRESET_NUM76;	break;
	case 77: ID=IDC_PRESET_NUM77;	break;	case 78: ID=IDC_PRESET_NUM78;	break;
	case 79: ID=IDC_PRESET_NUM79;	break;	case 80: ID=IDC_PRESET_NUM80;	break;
	//-------
	case 81: ID=IDC_PRESET_NUM81;	break;	case 82: ID=IDC_PRESET_NUM82;	break;
	case 83: ID=IDC_PRESET_NUM83;	break;	case 84: ID=IDC_PRESET_NUM84;	break;
	case 85: ID=IDC_PRESET_NUM85;	break;	case 86: ID=IDC_PRESET_NUM86;	break;
	case 87: ID=IDC_PRESET_NUM87;	break;	case 88: ID=IDC_PRESET_NUM88;	break;
	case 89: ID=IDC_PRESET_NUM89;	break;	case 90: ID=IDC_PRESET_NUM90;	break;
	case 91: ID=IDC_PRESET_NUM91;	break;	case 92: ID=IDC_PRESET_NUM92;	break;
	case 93: ID=IDC_PRESET_NUM93;	break;	case 94: ID=IDC_PRESET_NUM94;	break;
	case 95: ID=IDC_PRESET_NUM95;	break;	case 96: ID=IDC_PRESET_NUM96;	break;
	case 97: ID=IDC_PRESET_NUM97;	break;	case 98: ID=IDC_PRESET_NUM98;	break;
	case 99: ID=IDC_PRESET_NUM99;	break;	case 100: ID=IDC_PRESET_NUM100;	break;
	//-------
	case 101: ID=IDC_PRESET_NUM101;	break;	case 102: ID=IDC_PRESET_NUM102;	break;
	case 103: ID=IDC_PRESET_NUM103;	break;	case 104: ID=IDC_PRESET_NUM104;	break;
	case 105: ID=IDC_PRESET_NUM105;	break;	case 106: ID=IDC_PRESET_NUM106;	break;
	case 107: ID=IDC_PRESET_NUM107;	break;	case 108: ID=IDC_PRESET_NUM108;	break;
	case 109: ID=IDC_PRESET_NUM109;	break;	case 110: ID=IDC_PRESET_NUM110;	break;
	case 111: ID=IDC_PRESET_NUM111;	break;	case 112: ID=IDC_PRESET_NUM112;	break;
	case 113: ID=IDC_PRESET_NUM113;	break;	case 114: ID=IDC_PRESET_NUM114;	break;
	case 115: ID=IDC_PRESET_NUM115;	break;	case 116: ID=IDC_PRESET_NUM116;	break;
	case 117: ID=IDC_PRESET_NUM117;	break;	case 118: ID=IDC_PRESET_NUM118;	break;
	case 119: ID=IDC_PRESET_NUM119;	break;	case 120: ID=IDC_PRESET_NUM120;	break;
	//-------
	case 121: ID=IDC_PRESET_NUM121;	break;	case 122: ID=IDC_PRESET_NUM122;	break;
	case 123: ID=IDC_PRESET_NUM123;	break;	case 124: ID=IDC_PRESET_NUM124;	break;
	case 125: ID=IDC_PRESET_NUM125;	break;	case 126: ID=IDC_PRESET_NUM126;	break;
	case 127: ID=IDC_PRESET_NUM127;	break;	case 128: ID=IDC_PRESET_NUM128;	break;
	//-------
	}
return (ID);
}

